<?php

namespace Drupal\entity_io_queue\Service;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Queue\QueueFactory;

/**
 * Service for managing Entity IO export queue.
 */
class EntityIoQueueService {

  /**
   * The queue factory.
   *
   * @var \Drupal\Core\Queue\QueueFactory
   */
  protected QueueFactory $queueFactory;

  /**
   * Constructs a EntityIoQueueService object.
   *
   * @param \Drupal\Core\Queue\QueueFactory $queueFactory
   *   The queue factory.
   */
  public function __construct(QueueFactory $queueFactory) {
    $this->queueFactory = $queueFactory;
  }

  /**
   * Add an entity to the export queue.
   */
  public function addToExportQueue(EntityInterface $entity, array $options = []) {
    $queue = $this->queueFactory->get('entity_io_queue_export');

    $data = [
      'entity_type' => $entity->getEntityTypeId(),
      'entity_id' => $entity->id(),
      'depth' => $options['depth'] ?? 0,
      'max_depth' => $options['max_depth'] ?? 3,
      'selected_fields' => $options['selected_fields'] ?? [],
      'langcode' => $options['langcode'] ?? $entity->language()->getId(),
      'is_revision' => $options['is_revision'] ?? FALSE,
    ];

    return $queue->createItem($data);
  }

}
