<?php

namespace Drupal\entity_io\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormBuilderInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Returns JSON export for entities with field and depth selection.
 */
class EntityIoExportController extends ControllerBase implements ContainerInjectionInterface {

  /**
   * The form builder service.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected $formBuilder;

  /**
   * Constructs the controller.
   */
  public function __construct(FormBuilderInterface $form_builder) {
    $this->formBuilder = $form_builder;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('form_builder')
    );
  }

  /**
   * Display the export form and JSON result for any entity type.
   */
  public function export(
    ?EntityInterface $node = NULL,
    ?EntityInterface $taxonomy_term = NULL,
    ?EntityInterface $block_content = NULL,
    ?EntityInterface $user = NULL,
    ?EntityInterface $comment = NULL,
    ?EntityInterface $media = NULL,
  ) {
    $entity = $node ?? $taxonomy_term ?? $block_content ?? $user ?? $comment ?? $media;
    if (!$entity) {
      return [
        '#markup' => $this->t('No valid entity provided.'),
      ];
    }

    // Use injected form builder service instead of \Drupal::formBuilder().
    $form = $this->formBuilder->getForm('\Drupal\entity_io\Form\Export\EntityIoExportGenericForm', $entity);
    return $form;
  }

}
