<?php

namespace Drupal\entity_io\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form to configure export path and behavior for JSON files.
 */
class EntityExportSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'entity_io_export_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['entity_io.export_settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('entity_io.export_settings');

    // === Storage settings fieldset ===
    $form['storage_settings'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Storage settings'),
      '#description' => $this->t('Choose where and how exported JSON files will be saved.'),
    ];

    $form['storage_settings']['storage_scheme'] = [
      '#type' => 'radios',
      '#title' => $this->t('Select storage scheme'),
      '#description' => $this->t('Choose whether files will be stored in the public directory (accessible via URL) or the private directory (not accessible directly via URL).'),
      '#options' => [
        'public' => $this->t('Public (accessible via URL)'),
        'private' => $this->t('Private (not accessible via direct URL)'),
      ],
      '#default_value' => $config->get('storage_scheme') ?? 'public',
    ];

    $form['storage_settings']['directory'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Subdirectory name'),
      '#description' => $this->t("Folder name where files will be saved. Do not include leading or trailing slashes. Example: <code>exports</code>. Make sure the directory exists and is writable. \$settings[\'file_private_path\'], \$settings[\'file_temp_path\'], \$settings[\'file_public_path\'] must be set in settings.php to use the directory scheme."),
      '#default_value' => $config->get('directory') ?? 'entity_io_exports',
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('entity_io.export_settings')
      ->set('storage_scheme', $form_state->getValue('storage_scheme'))
      ->set('directory', $form_state->getValue('directory'))
      ->set('import_create_new_revision', $form_state->getValue('import_create_new_revision'))
      ->set('import_user', $form_state->getValue('import_user'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
