<?php

namespace Drupal\entity_io_purge\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Confirmation form for purging exported files.
 */
class PurgeConfirmForm extends ConfirmFormBase {

  /**
   * The entity types to purge.
   *
   * @var array
   */
  protected array $entityTypes;

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'entity_io_purge_confirm_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, array $entity_types = []) {
    $this->entityTypes = $entity_types;
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    if (in_array('*', $this->entityTypes)) {
      return $this->t('Are you sure you want to delete all exported files?');
    }

    return $this->t('Are you sure you want to delete exported files for: @types?', [
      '@types' => implode(', ', $this->entityTypes),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->t('This action cannot be undone. All selected exported JSON files will be permanently deleted.');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return new Url('entity_io_purge.form');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $url = Url::fromRoute('entity_io_purge.execute', [], [
      'query' => ['entity_types' => $this->entityTypes],
    ]);

    $form_state->setRedirectUrl($url);
  }

}
