<?php

namespace Drupal\entity_io_purge\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure purge settings.
 */
class PurgeSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'entity_io_purge_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['entity_io_purge.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('entity_io_purge.settings');

    $form['fieldset_info'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Automatic Purge Settings'),
    ];

    $form['fieldset_info']['description'] = [
      '#markup' => '<p>' . $this->t('Configure automatic purge settings for exported entity files.') . '</p>',
    ];

    $form['fieldset_info']['auto_purge'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable automatic purge'),
      '#description' => $this->t('Automatically purge exported files based on the settings below.'),
      '#default_value' => $config->get('auto_purge') ?? FALSE,
    ];

    $form['fieldset_info']['purge_frequency'] = [
      '#type' => 'select',
      '#title' => $this->t('Purge frequency'),
      '#description' => $this->t('How often should the automatic purge run?'),
      '#options' => [
        'daily' => $this->t('Daily'),
        'weekly' => $this->t('Weekly'),
        'monthly' => $this->t('Monthly'),
      ],
      '#default_value' => $config->get('purge_frequency') ?? 'weekly',
      '#states' => [
        'visible' => [
          ':input[name="auto_purge"]' => ['checked' => TRUE],
        ],
      ],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('entity_io_purge.settings')
      ->set('auto_purge', $form_state->getValue('auto_purge'))
      ->set('purge_frequency', $form_state->getValue('purge_frequency'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
