<?php
/**
 * @file
 * Hooks provided by the Entity IO module.
 */

/**
 * Allows modules to alter exported field values.
 * 
 * @param string $field_name
 *   The name of the field being altered.
 * @param string $field_type
 *   The type of the field being altered.
 * @param string $target_type
 *   The type of the target entity.
 * @param \Drupal\Core\Field\FieldInterface $field
 *   The field instance.
 * @param int $depth
 *   The current recursion depth.
 * @param int $max_depth
 *   The maximum allowed recursion depth.
 */
function hook_entity_io_export_FIELD_TYPE_alter(&$value, $field_name, $field_type, $target_type, &$field, &$depth, &$max_depth) {
    // Example:
    //  if ($field_type == 'my_custom_field_type') {
    //    $value = $field->getValue(); // Custom export logic here.
    //  }
}

/**
 * Allows modules to alter imported field values.
 * @param mixed $value
 *   The field value to be altered.
 * @param string $field_name
 *   The name of the field being altered.
 * @param string $field_type
 *   The type of the field being altered.
 */
function hook_entity_io_import_FIELD_TYPE_alter(&$value, $field_name, $field_type) {
    // Example:
    // if ($field_type == 'my_custom_field_type') {
    //   $value = ...; // Custom import logic here.
    // }
}

/**
 * Allows modules to validate imported field values.
 * 
 * @param bool $isValid
 *   Default TRUE. A boolean indicating whether the field value is valid. This parameter is passed by reference and can be modified to indicate validation failure.
 * @param string &$errorMessage
 *   An error message describing the validation failure. This parameter is passed by reference and can be modified to provide a custom error message.
 * @param mixed $value
 *   The field value to be validated.
 * @param string $field_name
 *   The name of the field being validated.
 * @param string $field_type
 *   The type of the field being validated.
 * @param int $delta
 */
function hook_entity_io_validate_FIELD_TYPE_alter(&$isValid, &$errorMessage, $value, $field_name, $field_type, $delta) {
    // Example:
    // if ($field_type == 'my_custom_field_type') {
    //   // Custom validation logic here.
    // }
}