(function (Drupal) {
  Drupal.behaviors.diff2Html = {
    attach: function (context, settings) {
      const oldElements = document.querySelectorAll("[id^='old-']");

      oldElements.forEach(oldEl => {
        const id = oldEl.id.split("-")[1];
        const newEl = document.getElementById("new-" + id);
        const container = document.getElementById("diff-container-" + id);

        if (!newEl || !container) return;

        const oldStr = oldEl.innerHTML.trim();
        const newStr = newEl.innerHTML.trim();

        const patch = Diff.createTwoFilesPatch(
          `old-${id}.html`,
          `new-${id}.html`,
          oldStr,
          newStr
        );

        const diffHtml = Diff2Html.html(patch, {
          drawFileList: false,
          matching: 'lines',
          outputFormat: 'side-by-side' // or 'line-by-line'
        });

        container.innerHTML = diffHtml;

        // 🔹 Hide unchanged lines
        container.querySelectorAll(".d2h-code-line").forEach(line => {
          if (
            !line.classList.contains("d2h-ins") && // not inserted
            !line.classList.contains("d2h-del")    // not deleted
          ) {
            line.style.display = "none";
          }
        });
      });
    }
  };
})(Drupal);
