(function (Drupal, once) {
  Drupal.behaviors.entityIoScrollToResult = {
    attach: function (context, settings) {
      // Escuta o evento AJAX global do Drupal.
      // Este evento dispara sempre que uma requisição AJAX termina.
      once('entity-io-scroll-ajax', 'body', context).forEach(() => {
        $(document).on('ajaxComplete', function (event, xhr, settings) {
          // Verifica se o botão clicado foi o de Export JSON.
          const $activeButton = $(document.activeElement);
          if ($activeButton.hasClass('entity-io-export-btn')) {
            const $textarea = $('#json-export-result textarea');
            if ($textarea.length) {
              setTimeout(() => {
                $textarea[0].scrollIntoView({ behavior: 'smooth', block: 'center' });
                $textarea.focus();
              }, 200);
            }
          }
        });
      });
    },
  };
})(Drupal, once);
