<?php

namespace Drupal\entity_io\Helper;

use Drupal\Core\Entity\EntityInterface;

/**
 * Helper class to load entities by type, bundle, and UUID.
 */
class EntityLogger {

  /**
   * Get the title/label for any entity type.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity to extract the title/label from.
   *
   * @return string
   *   The title or label of the entity, or a placeholder if none exists.
   */
  public static function getEntityTitle(EntityInterface $entity): string {
    $entity_type = $entity->getEntityTypeId();

    switch ($entity_type) {
      case 'node':
        return $entity->label();

      case 'taxonomy_term':
        return $entity->label();

      case 'paragraph':
        return 'Paragraph: ' . $entity->bundle() . ' (#' . $entity->id() . ')';

      case 'block_content':
        return $entity->label() ?? 'Block (#' . $entity->id() . ')';

      case 'comment':
        return $entity->get('subject')->value ?? 'Comment (#' . $entity->id() . ')';

      case 'user':
        return $entity->getDisplayName();

      case 'media':
        return $entity->label();
    }
    // If unknown entity, try label() or return type + ID.
    return method_exists($entity, 'label')
        ? $entity->label()
        : ucfirst($entity_type) . ' (#' . $entity->id() . ')';
  }

}
