<?php

namespace Drupal\entity_io\Service;

use Drupal\Core\File\FileSystemInterface;

/**
 * Service to save exported entity JSON to a file.
 */
final class EntityIoSaveFile {

  /**
   * Public URL to the exported file.
   *
   * @var string
   */
  public static $publicPath = '';
  /**
   * Public path including filename to the exported file.
   *
   * @var string
   */
  public static $publicPathFile = '';
  /**
   * Real file system path to the exported file.
   *
   * @var string
   */
  public static $publicRealPathFile = '';

  /**
   * Save file.
   */
  public static function save($json, $entity_type, $fileName) {
    $config = \Drupal::config('entity_io.export_settings');
    $scheme = $config->get('storage_scheme') ?? 'public';
    $directory = $config->get('directory') ?? 'entity_io_exports';
    self::$publicPath = $scheme . '://' . $directory . '/' . $entity_type;
    self::$publicPathFile = $scheme . '://' . $directory . '/' . $entity_type . '/' . $fileName;
    self::$publicRealPathFile = \Drupal::service('file_system')->realpath(self::$publicPathFile);

    \Drupal::service('file_system')->prepareDirectory(self::$publicPath, FileSystemInterface::CREATE_DIRECTORY | FileSystemInterface::MODIFY_PERMISSIONS);
    file_put_contents(\Drupal::service('file_system')->realpath(self::$publicPathFile), $json);

    return \Drupal::service('file_url_generator')->generateAbsoluteString(self::$publicPathFile);
  }

}
