# Entity Language Access

The module will add an *additional* access check to **canonical** routes of translatable content entity types and deny access, if the entity language differs from the current language.

For a full description of the module, visit the [project page](https://www.drupal.org/project/entity_language_access).

Submit bug reports and feature suggestions, or track changes in the [issue queue](https://git.drupalcode.org/project/entity_language_access/issues).


## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers


## Requirements

This module requires no modules outside of Drupal core.


## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

The module will be active for all translatable content entity types that have a canonical route in all languages.

You may optionally configure a fallback content to be shown instead of a general 403 error page for missing entity translations. The configured content **must** be translated into all available languages and accessible by all users.

1. Enable the module at *Administration* > *Extend*.
1. Optionally, configure a Node to use as fallback content at *Configuration* > *Region and language* > *Entity Language Access*.
1. Review the permissions provided by the module. There is a permission to bypass access checks by this module and a permission to administer the module's settings.


## Maintainers

See maintainers list [on the module's project page](https://www.drupal.org/project/entity_language_access).

This project has been partly sponsored by:

- [werk21 GmbH](https://www.werk21.de)
