<?php

namespace Drupal\entity_lifecycle;

use Drupal\Core\Config\Entity\DraggableListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a listing of Lifecycle Status entities.
 */
class LifecycleStatusListBuilder extends DraggableListBuilder {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'lifecycle_status_list';
  }

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header = [];
    $header['label'] = $this->t('Status');
    $header['id'] = $this->t('Machine name');
    $header['description'] = $this->t('Description');
    $header['is_default'] = $this->t('Default');
    $header['requires_review'] = $this->t('Requires Review');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\entity_lifecycle\Entity\LifecycleStatus $entity */
    $row = [];
    $row['label'] = $entity->label();
    $row['id'] = ['#plain_text' => $entity->id()];
    $row['description'] = ['#plain_text' => $entity->getDescription()];
    $row['is_default'] = [
      '#markup' => $entity->isDefault() ? $this->t('Yes') : $this->t('No'),
    ];
    $row['requires_review'] = [
      '#markup' => $entity->requiresReview() ? $this->t('Yes') : $this->t('No'),
    ];
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    parent::submitForm($form, $form_state);
    $this->messenger()->addStatus($this->t('The status order has been saved.'));
  }

  /**
   * {@inheritdoc}
   */
  public function render(): array {
    $build = parent::render();
    $build['#empty'] = $this->t('No lifecycle statuses have been created yet. <a href=":url">Add a status</a>.', [
      ':url' => '/admin/config/content/entity-lifecycle/statuses/add',
    ]);
    return $build;
  }

}
