# Entity Lifecycle Module

Manages content lifecycle status for nodes, media, and user entities, helping
editors identify and review outdated content.

## How It Works

The module tracks content freshness through an automated lifecycle:

1. **New/edited content** is automatically marked as "Current" with a
   timestamp
2. **Cron scans** evaluate content against configured conditions (age,
   inactivity, etc.)
3. **Content matching conditions** gets assigned a status like "Needs Review"
   or "Outdated"
4. **Editors see a banner** on content that needs attention
5. **Editing content** automatically resets it to "Current", restarting the
   cycle

This ensures outdated content is systematically identified without requiring
manual tracking.

## Features

- Automatic status assignment on content save
- Configurable lifecycle statuses with colors and review flags
- Cron-based scanning with extensible condition plugins
- Review banner for content needing attention
- Views integration for content overview
- Per-bundle configuration for content types and media types
- User account lifecycle tracking (via submodule)
- Drush commands for manual scanning

## Installation

Enable the module: `drush en entity_lifecycle`

## Configuration

### Global Settings

Navigate to `/admin/config/content/entity-lifecycle` to configure:

- **Automatic scan interval**: How often the lifecycle scanner runs during cron
  - Disabled: No automatic scanning
  - Every cron run: Scan on every cron execution
  - Every 6/12 hours: Scan at the specified interval
  - Daily (default): Scan once per day
  - Every 2 days / Weekly: Less frequent scanning
- **Display banner**: Show/hide the review notification banner
- **Banner visibility roles**: Which roles see the review banner

The scan runs on the first cron execution after the configured interval has
passed. Time-based conditions (like content age) are evaluated during these
scans.

### Lifecycle Statuses

Manage statuses at `/admin/config/content/entity-lifecycle/statuses`:

Default statuses:
- **Current**: Content is current (default for new/edited content)
- **Needs Review**: Content requires editorial review
- **Reviewed OK**: Content has been reviewed and confirmed as accurate
- **Outdated**: Content is outdated and should be updated or archived

### Per-Bundle Settings

Configure lifecycle scanning for each content type via the content type edit
form (`/admin/structure/types/manage/[type]`) under "Lifecycle settings":

- **Enable lifecycle scanning**: Turn scanning on/off for this bundle
- **Review validity period**: Months before content needs re-review
- **Lifecycle conditions**: Define conditions that trigger status changes

### Condition Plugins

Built-in conditions:
- **Content age**: Based on creation date and/or last modification date

### Submodules

- **entity_lifecycle_user**: User account lifecycle tracking with login-based
  conditions
- **entity_lifecycle_radioactivity**: Based on Radioactivity energy
- **entity_lifecycle_linkchecker**: Based on broken links count

## User Lifecycle (Submodule)

The `entity_lifecycle_user` submodule extends lifecycle tracking to user
accounts, helping administrators identify inactive users.

### Enabling User Lifecycle

1. Enable the submodule: `drush en entity_lifecycle_user`
2. Navigate to `/admin/config/content/entity-lifecycle`
3. Check "User accounts" in the Enabled entity types section
4. Configure conditions at `/admin/config/people/accounts` under "User
   Lifecycle Settings"

### User-Specific Conditions

- **Last login**: Based on time since user's last login
- **Account age**: Based on account creation date

### User Lifecycle Review

View and manage user lifecycle status at `/admin/people/lifecycle-review`,
accessible via "Lifecycle Review" tab under People.

## Drush Commands

```bash
# Scan for outdated content (dry run)
drush entity-lifecycle:scan --dry-run

# Scan and mark outdated content
drush entity-lifecycle:scan

# Scan specific bundle
drush entity-lifecycle:scan --entity-type=node --bundle=article
```

## Requirements

- Drupal 10.x or 11.x
- PHP 8.1+

## Documentation

- [Developer Documentation](DEVELOPERS.md) - Architecture, APIs, and extending

## License

GPL-2.0-or-later
