# Entity Lifecycle Entity Usage Integration

This module integrates the [Entity Usage](https://www.drupal.org/project/entity_usage) module with Entity Lifecycle to provide conditions based on entity usage tracking.

## Features

### Unused Entity Condition

Identifies content that is not referenced or used anywhere in the site. This is useful for:

- Finding orphaned media files
- Detecting unused taxonomy terms
- Identifying content that can be safely archived or deleted
- Maintaining a clean content repository

## Configuration

After enabling this module, a new condition type "Unused entity" becomes available when configuring entity lifecycle rules at:

`/admin/config/content/entity-lifecycle`

### Condition Settings

- **Maximum usage count**: Content used this many times or fewer matches the condition
  - Set to `0` to match only completely unused content
  - Set to `1` to match content used once or not at all
  - Higher values can identify low-usage content

## Requirements

- Entity Lifecycle (parent module)
- Entity Usage module (^2.0)

## Usage Example

Configure a lifecycle rule that marks media files as "outdated" if they are not used anywhere:

1. Navigate to `/admin/config/content/entity-lifecycle`
2. Enable lifecycle tracking for Media entities
3. Add a condition group:
   - Condition: "Unused entity"
   - Maximum usage count: 0
   - Status: "Outdated"

Now media files that are uploaded but never referenced will automatically be marked as outdated.

## Technical Details

The condition queries the `entity_usage` table to count how many times an entity is referenced. The count represents the sum of all usages across all source entities and fields.
