<?php

namespace Drupal\entity_lifecycle\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Lifecycle Condition annotation object.
 *
 * Plugin Namespace: Plugin\LifecycleCondition.
 *
 * @Annotation
 */
class LifecycleCondition extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the condition.
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $label;

  /**
   * A brief description of the condition.
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public $description;

  /**
   * The entity types this condition applies to.
   *
   * Leave empty for all supported entity types.
   *
   * @var array
   */
  public $entity_types = [];

  /**
   * The category for grouping conditions in the UI.
   *
   * Available categories:
   * - "general": General conditions that apply to all entity types.
   * - "content": Content-related conditions (age, broken links, etc.).
   * - "user": User account conditions (login, account age, etc.).
   * - "usage": Entity usage and reference conditions.
   *
   * @var string
   */
  public $category = 'general';

  /**
   * The weight of the condition for ordering.
   *
   * @var int
   */
  public $weight = 0;

}
