# Entity Lifecycle User

Extends the Entity Lifecycle module with user account lifecycle tracking,
helping administrators identify and manage inactive user accounts.

## Features

- Track user lifecycle status based on login activity
- Configurable conditions (last login, account age)
- User lifecycle review dashboard
- Integration with Drupal's Account settings page
- Per-user override options

## Installation

1. Enable the module:
   ```bash
   drush en entity_lifecycle_user
   ```

2. Enable user lifecycle tracking at `/admin/config/content/entity-lifecycle`
   by checking "User accounts"

3. Configure conditions at `/admin/config/people/accounts` under "User
   Lifecycle Settings"

## Configuration

### Enabling User Lifecycle

User lifecycle tracking is enabled/disabled on the main Entity Lifecycle
settings page (`/admin/config/content/entity-lifecycle`). This follows the same
pattern as enabling other entity types like Content or Media.

### Configuring Conditions

When enabled, the Account settings page (`/admin/config/people/accounts`)
shows a "User Lifecycle Settings" section with:

- **Allow per-user override**: Let administrators exclude specific users or set
  custom review periods
- **Default review validity**: Months before a user account needs review
- **Lifecycle conditions**: Table of conditions that trigger status changes

### Condition Types

#### Last Login

Evaluates time since the user's last login:

- **Minimum months since last login**: Users inactive for at least this many
  months will match
- **Include users who have never logged in**: Also match users with no login
  history

#### Account Age

Evaluates time since account creation:

- **Minimum account age (months)**: Accounts older than this will match

### Condition Evaluation Order

Conditions are evaluated top to bottom. The first matching condition wins.
Typical configuration:

| Order | Condition | Status |
|-------|-----------|--------|
| 1 | Last login >= 12 months OR never logged in | Outdated |
| 2 | Last login >= 6 months | Needs Review |
| 3 | Last login >= 0 months (any login) | Current |

## User Lifecycle Review

Access the review dashboard at `/admin/people/lifecycle-review` or via the
"Lifecycle Review" tab under People.

The dashboard provides:

- **Summary**: Count of users per status with visual indicators
- **Filters**: Filter by lifecycle status and account status (active/blocked)
- **User table**: Sortable list with username, email, roles, lifecycle status,
  last reviewed date, and account status
- **Actions**: Links to edit user or view profile

## Permissions

| Permission | Description |
|------------|-------------|
| `administer user lifecycle` | Configure user lifecycle settings and review users |

## Fields Added to Users

When user lifecycle is enabled, the following fields are added to user
entities:

| Field | Description |
|-------|-------------|
| `lifecycle_status` | Current lifecycle status |
| `lifecycle_last_reviewed` | Timestamp of last review |
| `lifecycle_exclude` | Exclude from automatic scanning |
| `lifecycle_override_days` | Custom review period (days) |

## Requirements

- Entity Lifecycle (parent module)
- Drupal 10.x or 11.x
- PHP 8.1+

## Related

- [Entity Lifecycle Documentation](../../README.md)
- [Developer Documentation](../../DEVELOPERS.md)
