(function () {
  'use strict';

  /**
   * Update URL with filter parameters.
   */
  function updateFilters() {
    var lifecycleSelect = document.getElementById('lifecycle-status-filter');
    var accountSelect = document.getElementById('account-status-filter');

    if (!lifecycleSelect || !accountSelect) {
      return;
    }

    var basePath = lifecycleSelect.getAttribute('data-base-path') || window.location.pathname;
    var params = new URLSearchParams();

    var lifecycleValue = lifecycleSelect.value;
    var accountValue = accountSelect.value;

    if (lifecycleValue) {
      params.set('status', lifecycleValue);
    }
    if (accountValue) {
      params.set('account_status', accountValue);
    }

    var newUrl = basePath;
    if (params.toString()) {
      newUrl += '?' + params.toString();
    }

    window.location.href = newUrl;
  }

  /**
   * Initialize filters on page load.
   */
  function init() {
    var lifecycleSelect = document.getElementById('lifecycle-status-filter');
    var accountSelect = document.getElementById('account-status-filter');

    if (lifecycleSelect) {
      lifecycleSelect.addEventListener('change', updateFilters);
    }

    if (accountSelect) {
      accountSelect.addEventListener('change', updateFilters);
    }
  }

  // Initialize when DOM is ready.
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

})();
