<?php

namespace Drupal\entity_logger;

use Drupal\Core\Entity\EntityInterface;

/**
 * Factory class for entity logger instances.
 */
class EntityLoggerInstanceFactory implements EntityLoggerInstanceFactoryInterface {

  /**
   * Constructs a new EntityLogger Instance object.
   *
   * @param \Drupal\entity_logger\EntityLoggerInstanceInterface $entityLoggerInstance
   *   The entity logger instance service.
   */
  public function __construct(protected EntityLoggerInstanceInterface $entityLoggerInstance) {}

  /**
   * {@inheritdoc}
   */
  public function get(EntityInterface $entity, ?string $channel = NULL): EntityLoggerInstance {
    $this->entityLoggerInstance->setEntity($entity);
    if ($channel) {
      $this->entityLoggerInstance->setLoggerChannel($channel);
    }
    return $this->entityLoggerInstance;
  }

}
