<?php

declare(strict_types=1);

namespace Drupal\entity_logger;

/**
 * Helper class for Entity Logger schema definition.
 */
class EntityLoggerSchemaHelper {

  /**
   * Get a list of available entity type IDS to enable entity logger on.
   *
   * @return array
   *   List of entity type IDs to enable entity logger on.
   */
  public static function getAvailableEntityTypeIdsForLogging(): array {
    $service = \Drupal::service('entity_logger');
    return array_keys($service->getAvailableEntityTypesForLogging());
  }

}
