<?php

declare(strict_types=1);

namespace Drupal\entity_logger\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Provides Help hook implementations.
 */
class HelpHooks {

  /**
   * Implements hook_help().
   *
   * @param string $routeName
   *   The route name.
   * @param \Drupal\Core\Routing\RouteMatchInterface $routeMatch
   *   The route match service.
   *
   * @return string|null
   *   The help text when the route name is correct, otherwise null.
   */
  #[Hook('help')]
  public function help(string $routeName, RouteMatchInterface $routeMatch): ?string {
    if ($routeName === 'help.page.entity_logger') {
      $output = '<h3>' . t('About') . '</h3>';
      $output .= '<p>' . t('This module allows adding log messages to entities.
    Log messages are shown on a "Log" tab on the entity they are associated
    with.') . '</p>';
      $output .= '<p>' . t('Log messages can be added to a configurable set of
    entity types.') . '</p>';
      $output .= '<p>' . t('This module is intended to be used in cases where
    you want to store log messages but the default Drupal watchdog / logging
    interface is insufficient. E.g. you want the log messages to appear within
    the context of an entity, you want more
    persistency in the storage of these log message, and / or you want specific
    roles to access these log messages, while you do not want these roles to
    access the default Drupal watchdog UI.') . '</p>';

      return $output;
    }

    return NULL;
  }

}
