<?php

namespace Drupal\entity_manager;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;

/**
 * Modifies the current_route_match service to use a custom route match class.
 *
 * This service provider alters the 'current_route_match' service to use
 * a custom implementation that extends the default functionality.
 */
class EntityManagerServiceProvider extends ServiceProviderBase {

  /**
   *
   */
  public function alter(ContainerBuilder $container) {
    if ($container->hasDefinition('current_route_match')) {
      $definition = $container->getDefinition('current_route_match');
      $definition->setClass('Drupal\entity_manager\Routing\CustomCurrentRouteMatch');
    }
  }

}
