<?php

namespace Drupal\entity_manager\Plugin\EntityManager;

use Drupal\Core\Entity\EntityInterface;
use Drupal\entity_manager\Entity\EntityManagerItem;
use Drupal\entity_manager\EntityManagerPluginBase;

/**
 * Plugin implementation of the entity_manager.
 *
 * @EntityManager(
 *   id = "ai_seo",
 *   label = @Translation("Analyze SEO"),
 *   weight = 11,
 *   description = @Translation("Analyze SEO with AI.")
 * )
 */
class AiSEO extends EntityManagerPluginBase {

  /**
   *
   */
  public function buildPage(EntityManagerItem $entity_manager_item, ?EntityInterface $entity = NULL) {
    $build = [
      '#markup' => t('No SEO Reports for %title', ['%title' => $entity->label()]),
    ];
    if (\Drupal::moduleHandler()->moduleExists('ai_seo')) {
      $build = \Drupal::formBuilder()->getForm('\Drupal\ai_seo\Form\AnalyzeNodeForm');
    }
    return $build;
  }

}
