<?php

namespace Drupal\entity_manager\Plugin\EntityManager;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Language\LanguageInterface;
use Drupal\Core\Url;
use Drupal\entity_manager\Entity\EntityManagerItem;
use Drupal\entity_manager\EntityManagerPluginBase;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\Exception\ResourceNotFoundException;

/**
 * Plugin implementation of the entity_manager.
 *
 * @EntityManager(
 *   id = "layout",
 *   label = @Translation("Layout"),
 *   weight = 9,
 *   description = @Translation("Entity layout with layout builder.")
 * )
 */
class Layout extends EntityManagerPluginBase {

  /**
   *
   */
  public function buildPage(EntityManagerItem $entity_manager_item, ?EntityInterface $entity = NULL) {
    \Drupal::request()->query->remove('destination');
    $content_language = \Drupal::languageManager()->getCurrentLanguage(LanguageInterface::TYPE_CONTENT);
    $path = "/" . $entity->toUrl('canonical')->getInternalPath() . "/layout";
    $url = Url::fromUserInput($path, ['language' => $content_language]);
    if ($url) {
      $response = new RedirectResponse($url->toString());
      return $response;
    }
    else {
      throw new ResourceNotFoundException();
    }
  }

  /**
   *
   */
  public function alterOperationLinks(EntityManagerItem $entity_manager_item, EntityInterface $entity, array &$operations) {
    if (!$this->isMenuAction($entity_manager_item)) {
      $url = Url::fromRoute(
            "entity_manager.entity.{$entity_manager_item->id()}.{$this->getPluginId()}_page",
            [
              'entity' => $entity->id(),
            ], [
              'attributes' => [
                'target' => '_blank',
              ],
              'language' => $entity->language(),
            ]
        );
      $access = \Drupal::accessManager()->checkNamedRoute($url->getRouteName(), $url->getRouteParameters());
      if ($access) {
        $operations[$this->getPluginId()] = [
          'title' => $this->label(),
          'url' => $url,
          'weight' => $this->getWeight(),
        ];
      }
      else {
        unset($operations[$this->getPluginId()]);
      }
    }
  }

  /**
   *
   */
  public function isMenuTask(EntityManagerItem $entity_manager_item) {
    return FALSE;
  }

}
