<?php

namespace Drupal\entity_manager\Plugin\EntityManager;

use Drupal\content_moderation\Form\EntityModerationForm;
use Drupal\Core\Entity\EntityInterface;
use Drupal\entity_manager\Entity\EntityManagerItem;
use Drupal\entity_manager\EntityManagerPluginBase;

/**
 * Plugin implementation of the entity_manager.
 *
 * @EntityManager(
 *   id = "moderation",
 *   label = @Translation("Moderation"),
 *   weight = 3,
 *   description = @Translation("Moderation Workflow.")
 * )
 */
class Moderation extends EntityManagerPluginBase {

  /**
   *
   */
  public function buildPage(EntityManagerItem $entity_manager_item, ?EntityInterface $entity = NULL) {
    $build = \Drupal::formBuilder()->getForm(EntityModerationForm::class, $entity);
    return $build;
  }

}
