<?php

namespace Drupal\entity_manager\Plugin\EntityManager;

use Drupal\Core\Entity\EntityInterface;
use Drupal\entity_manager\Entity\EntityManagerItem;
use Drupal\entity_manager\EntityManagerPluginBase;
use Symfony\Component\Routing\Route;

/**
 * Plugin implementation of the entity_manager.
 *
 * @EntityManager(
 *   id = "translate",
 *   label = @Translation("Translate"),
 *   weight = 10,
 *   description = @Translation("Entity translations.")
 * )
 */
class Translate extends EntityManagerPluginBase {

  /**
   *
   */
  public function buildPage(EntityManagerItem $entity_manager_item, ?EntityInterface $entity = NULL) {
    $build = [
      '#markup' => t('No translations for %title', ['%title' => $entity->label()]),
    ];
    if ($entity->getEntityType()->hasLinkTemplate('drupal:content-translation-overview')) {
      // Get route from route name.
      $entity_type_id = $entity->getEntityTypeId();
      $route_name = "entity.$entity_type_id.content_translation_overview";
      $route = \Drupal::service('router.route_provider')->getRouteByName($route_name);
      $parent_controller_id = $route->getDefault('_controller');

      // Let the original controller build the form it wants to.
      if ($parent_controller = \Drupal::service('controller_resolver')->getControllerFromDefinition($parent_controller_id)) {
        $route_match = \Drupal::routeMatch();
        $build = call_user_func([$parent_controller[0], $parent_controller[1]], $route_match, $entity_type_id);
      }
    }
    return $build;
  }

  /**
   *
   */
  public function alterRoute(Route $route, EntityManagerItem $entity_manager_item) {
    $route->setDefault('_parent_controller', "\Drupal\content_translation\Controller\ContentTranslationController::overview");
  }

}
