<?php

declare(strict_types=1);

namespace Drupal\entity_manager\Plugin\views\argument_default;

use Drupal\Core\Cache\CacheableDependencyInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\user\Entity\User;
use Drupal\views\Attribute\ViewsArgumentDefault;
use Drupal\views\Plugin\views\argument_default\ArgumentDefaultPluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * @todo Add plugin description here.
 */
#[ViewsArgumentDefault(
    id: 'entity_manager_current_user_orgnization',
    title: new TranslatableMarkup('Current User Orgnization'),
)]
final class CurrentUserOrgnization extends ArgumentDefaultPluginBase implements CacheableDependencyInterface {

  /**
   * Constructs a new CurrentUserOrgnization instance.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    private readonly AccountProxyInterface $currentUser,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new self(
          $configuration,
          $plugin_id,
          $plugin_definition,
          $container->get('current_user'),
      );
  }

  /**
   * {@inheritdoc}
   *
   * @todo Make sure the return type-hint matches the argument type.
   */
  public function getArgument() {

    $user = $this->currentUser->isAuthenticated() ? User::load($this->currentUser->id()) : NULL;
    if ($user && $user->hasField('field_orgnization')) {
      $user_orgnization = $user->get('field_orgnization')->getValue();
      if (!empty($user_orgnization)) {
        $user_orgs = array_column($user_orgnization, 'target_id');
        return implode('+', $user_orgs);
      }
    }

    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheMaxAge(): int {
    return 0;
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheContexts(): array {
    // @todo Use 'url.path' or 'url.query_args:%key' contexts if the argument
    // comes from URL.
    return ['user'];
  }

}
