<?php

namespace Drupal\entity_manager;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\entity_manager\Entity\EntityManagerItem;

/**
 * EntityManager plugin manager.
 */
class EntityManagerPluginManager extends DefaultPluginManager {

  /**
   * Constructs EntityManagerPluginManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct(
          'Plugin/EntityManager',
          $namespaces,
          $module_handler,
          'Drupal\entity_manager\EntityManagerInterface',
          'Drupal\entity_manager\Annotation\EntityManager'
      );
    $this->alterInfo('entity_manager_info');
    $this->setCacheBackend($cache_backend, 'entity_manager_plugins');
  }

  /**
   *
   */
  public static function isEnabled(EntityManagerItem $entity, $plugin_id) {
    $enabled = $entity->get('plugins');
    return in_array($plugin_id, $enabled);
  }

}
