<?php

namespace Drupal\entity_manager\Plugin\EntityManager;

use Drupal\Core\Entity\EntityInterface;
use Drupal\entity_manager\Entity\EntityManagerItem;

/**
 * Plugin implementation of the entity_manager.
 *
 * @EntityManager(
 *   id = "add",
 *   label = @Translation("Add"),
 *   weight = 1,
 *   description = @Translation("Entity add action.")
 * )
 */
class EntityAdd extends EntityFormBase {

  /**
   *
   */
  public function buildPage(EntityManagerItem $entity_manager_item, ?EntityInterface $entity = NULL) {
    $entity_type = $this->entityTypeManager->getDefinition($entity_manager_item->get('entity_type'));
    $this->form_key = 'add';
    $storage = $this->entityTypeManager->getStorage($entity_manager_item->get('entity_type'));
    $entity = $storage->create(
          [
            $entity_type->getKey('bundle') => $entity_manager_item->get('entity_bundle'),
            $entity_type->getKey('uid') => \Drupal::currentUser()->id(),
          ]
      );
    return parent::buildPage($entity_manager_item, $entity);
  }

  /**
   *
   */
  public function isMenuAction(EntityManagerItem $entity_manager_item) {
    return TRUE;
  }

}
