<?php

namespace Drupal\entity_manager\Routing;

use Drupal\Core\Routing\CurrentRouteMatch;
use Drupal\Core\Routing\RouteMatch;
use Symfony\Component\HttpFoundation\Request;

/**
 *
 */
class CustomCurrentRouteMatch extends CurrentRouteMatch {

  /**
   * {@inheritdoc}
   */
  protected function getRouteMatch(Request $request) {
    if (isset($this->routeMatches[$request])) {
      $route_match = $this->routeMatches[$request];
    }
    else {
      if ($entity_manager_item = $request->attributes->get('entity_manager_item')) {
        $request->attributes->set($entity_manager_item->get('entity_type'), $request->attributes->get('entity'));
        $raw = $request->attributes->get('_raw_variables');
        $raw->set($entity_manager_item->get('entity_type'), $raw->get('entity'));
        $request->attributes->set('_raw_variables', $raw);
      }
      $route_match = RouteMatch::createFromRequest($request);

      // Since getRouteMatch() might be invoked both before and after routing
      // is completed, only statically cache the route match after there's a
      // matched route.
      if ($route_match->getRouteObject()) {
        $this->routeMatches[$request] = $route_match;
      }
    }
    return $route_match;
  }

}
