<?php

namespace Drupal\entity_mesh\Batches;

use Drupal\menu_link_content\MenuLinkContentInterface;

/**
 * Batch for nodes.
 */
class MenuBatch implements BatchInterface {

  /**
   * {@inheritdoc}
   */
  public static function getItemsForOperation() {
    $menu_ids = \Drupal::entityTypeManager()
      ->getStorage('menu_link_content')
      ->getQuery()
      ->accessCheck(FALSE)
      ->execute();
    return $menu_ids;
  }

  /**
   * {@inheritdoc}
   */
  public static function operation($id, $count, $num_item, &$context) {
    $menu_item = \Drupal::entityTypeManager()
      ->getStorage('menu_link_content')
      ->load($id);
    if ($menu_item instanceof MenuLinkContentInterface) {
      \Drupal::service('entity_mesh.menu')->processEntity($menu_item);
    }

    $context['results'][] = $id;
    $context['message'] = t('Running Batch "@count|@num_item" (menu)',
      ['@count' => $count, '@num_item' => $num_item]
    );
  }

  /**
   * {@inheritdoc}
   */
  public static function clearEntityMesh() {
    \Drupal::service('entity_mesh.repository')->deleteSourceByType('menu', []);
  }

}
