<?php

namespace Drupal\entity_mesh\Batches;

use Drupal\node\NodeInterface;

/**
 * Batch for nodes.
 */
class NodeBatch implements BatchInterface {

  /**
   * {@inheritdoc}
   */
  public static function getItemsForOperation() {
    $bundle_conditions = [];
    $config = \Drupal::configFactory()->getEditable('entity_mesh.settings');
    $enabled_types = $config->get('source_types') ?? [];

    if (!isset($enabled_types['node']['enabled']) || $enabled_types['node']['enabled'] === FALSE) {
      return [];
    }

    $enabled_bundles = $enabled_types['node']['bundles'] ?? [];
    if (!empty($enabled_bundles)) {
      foreach ($enabled_bundles as $bundle => $enabled) {
        if ($enabled === TRUE) {
          $bundle_conditions[] = $bundle;
        }
      }
    }

    $query = \Drupal::entityTypeManager()
      ->getStorage('node')
      ->getQuery()
      ->accessCheck();

    if (!empty($bundle_conditions)) {
      $query->condition('type', $bundle_conditions, 'IN');
    }

    $nids = $query->execute();
    return $nids;
  }

  /**
   * {@inheritdoc}
   */
  public static function operation($id, $count, $num_item, &$context) {
    $node = \Drupal::entityTypeManager()
      ->getStorage('node')
      ->load($id);
    if ($node instanceof NodeInterface) {
      \Drupal::service('entity_mesh.entity_render')->processEntity($node);
    }

    $context['results'][] = $id;
    $context['message'] = t('Running Batch "@count|@num_item" (node)',
      ['@count' => $count, '@num_item' => $num_item]
    );
  }

  /**
   * {@inheritdoc}
   */
  public static function clearEntityMesh() {
    \Drupal::service('entity_mesh.repository')->deleteSourceByType('entity_render', ['source_entity_type' => 'node']);
  }

}
