<?php

namespace Drupal\entity_mesh\Form;

use Drupal\Core\Database\Connection;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\entity_mesh\Batches\GeneralBatch;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Form with examples on how to use cache.
 */
class BatchForm extends FormBase {

  /**
   * The database connection.
   *
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Constructor.
   *
   * @param \Drupal\Core\Database\Connection $database
   *   The database connection.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The Entity Type Manager service.
   */
  final public function __construct(Connection $database, EntityTypeManagerInterface $entity_type_manager) {
    $this->database = $database;
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('database'),
      $container->get('entity_type.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'entity_mesh_batch_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['description'] = [
      '#type' => 'item',
      '#markup' => '<h2>' . $this->t('Generate the mesh') . '</h2>',
    ];

    $form['details']['info'] = [
      '#markup' => $this->t('This process may take a wile depending on the number of entities in your site.'),
    ];

    $form['details']['mesh_type'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Select the type of mess process you want to generate'),
      '#options' => [
        'node' => $this->t('Node'),
      // 'menu' => $this->t('Menu'),
      ],
      '#required' => TRUE,
      '#default_value' => [],
    ];

    $form['actions']['#type'] = 'actions';
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Generate mesh'),
      '#button_type' => 'primary',
    ];

    // By default, render the form using system-config-form.html.twig.
    $form['#theme'] = 'system_config_form';

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $mesh_type_values = $form_state->getValue('mesh_type');
    $batch = GeneralBatch::generateBatch($mesh_type_values);
    batch_set($batch->toArray());
  }

}
