<?php

namespace Drupal\entity_normalization_normalizers\Normalizer;

use Drupal\Core\Entity\EntityInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

/**
 * Converts the entity into the url.
 */
class EntityUrlNormalizer implements NormalizerInterface {

  /**
   * {@inheritdoc}
   */
  public function normalize($object, $format = NULL, array $context = []): array|string|int|float|bool|\ArrayObject|NULL {
    /** @var \Drupal\Core\Entity\EntityInterface $object */

    return $object->toUrl()->toString(TRUE)->getGeneratedUrl();
  }

  /**
   * {@inheritdoc}
   */
  public function supportsNormalization($data, ?string $format = null, array $context = []): bool {
    return $data instanceof EntityInterface;
  }

}
