<?php

namespace Drupal\entity_normalization_normalizers\Normalizer;

use Drupal\node\NodeTypeInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

/**
 * Converts the node type into the value.
 */
class NodeTypeNormalizer implements NormalizerInterface {

  /**
   * {@inheritdoc}
   */
  public function normalize($object, $format = NULL, array $context = []): array|string|int|float|bool|\ArrayObject|NULL {
    /** @var \Drupal\node\NodeTypeInterface $object */
    return $object->id();
  }

  /**
   * {@inheritdoc}
   */
  public function supportsNormalization($data, ?string $format = null, array $context = []): bool {
    return $data instanceof NodeTypeInterface;
  }

}
