<?php

namespace Drupal\entity_notes\Entity;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Entity Note entity.
 */
class EntityNoteAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\entity_notes\Entity\EntityNoteInterface $entity */

    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished entity note entities');
        }
        return AccessResult::allowedIfHasPermission($account, 'view published entity note entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit entity note entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete entity note entities');

    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add entity note entities');
  }

}
