<?php

namespace Drupal\entity_notes\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\Core\Entity\EntityPublishedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Entity Note entities.
 *
 * @ingroup entity_notes
 */
interface EntityNoteInterface extends ContentEntityInterface, EntityChangedInterface, EntityPublishedInterface, EntityOwnerInterface {

  /**
   * Gets the Entity Note creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Entity Note.
   */
  public function getCreatedTime();

  /**
   * Sets the Entity Note creation timestamp.
   *
   * @param int $timestamp
   *   The Entity Note creation timestamp.
   *
   * @return \Drupal\entity_notes\Entity\EntityNoteInterface
   *   The called Entity Note entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Gets the note text.
   *
   * @return string
   *   The note.
   */
  public function getNote();

  /**
   * Sets the note text.
   *
   * @param string $note
   *   The note text.
   *
   * @return $this
   */
  public function setNote($note);

}
