<?php

namespace Drupal\entity_notes\Entity;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Builds a listing of Entity Note entities.
 */
class EntityNotesListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  protected function getDefaultOperations(EntityInterface $entity) {
    $default_operations = parent::getDefaultOperations($entity);

    if ($entity->access('view')) {
      $default_operations['view'] = [
        'title' => $this->t('View'),
        'url' => $entity->toUrl(),
        'weight' => -5,
      ];
    }

    return $default_operations;
  }

}
