<?php

namespace Drupal\entity_notes\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Entity Notes local tasks.
 *
 * Adds a tab for each entity that Entity Notes is enabled on.
 */
class EntityNotesLocalTasks extends DeriverBase implements ContainerDeriverInterface {

  use StringTranslationTrait;

  /**
   * The Entity Notes config.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $config;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $container->get('config.factory')
    );
  }

  /**
   * EntityNotesLocalTasks constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
    $this->config = $config_factory->get('entity_notes.settings');
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $entity_types = $this->config->get('entity_types');

    if ($entity_types) {
      foreach ($entity_types as $entity_type_id) {
        $this->derivatives["entity_note.$entity_type_id"] = $base_plugin_definition;
        $this->derivatives["entity_note.$entity_type_id"]['title'] = $this->t('Entity Notes');
        $this->derivatives["entity_note.$entity_type_id"]['route_name'] = "entity_notes.$entity_type_id";
        $this->derivatives["entity_note.$entity_type_id"]['base_route'] = "entity.$entity_type_id.canonical";
        $this->derivatives["entity_note.$entity_type_id"]['weight'] = 99;
      }
    }

    return parent::getDerivativeDefinitions($base_plugin_definition);
  }

}
