# Entity Print CSS Injector

This module ensures that the appropriate CSS is used when exporting PDF via Entity Print
is integrated automatically - either:

1. From the **Asset Injector** (`sites/default/files/asset_injector/css/...`),
2. and static CSS files in `sites/default/files/static/entity_print_css/...` (recursive).

This eliminates the need to add a `hook_preprocess_entity_print()` in each theme.

---

## Configuration

1. install modul: `composer require drupal/entity_print_css_injector`
2. Create a file `sites/default/files/static/entity_print_css/` if you don't use Asset Injector CSS.
3. setup entity print for printout nodes and use it, don't forget the debug mode

## Usage

1. Place Asset Injector CSS with the prefix `epcss_` or fallback CSS files in the appropriate directories.
2. Ensure wkhtmltopdf is installed and configured in Entity Print.
3. Ensure you use **css only**!
