# Entity Reference Tab Formatter

This custom module adds an accessible tab/accordion field formatter for
`entity_reference` and `entity_reference_revisions` fields. It is built to work
well with Paragraphs but can be used on any entity reference field.

## Features

- Switch between **Tabs** or **Accordion** display styles without changing the
  stored data.
- Supports both single-field output and fully rendered referenced entities,
  respecting their configured view modes.
- JavaScript behaviors use Drupal core `once()` and avoid deprecated jQuery UI
  dependencies.
- Accessible markup and keyboard navigation defaults (first item visible without
  JavaScript, screen-reader friendly attributes).

## Installation

1. Place the module in `docroot/modules/custom/entity_ref_tab_formatter`.
2. Enable it through **Extend → Custom** or with Drush:
   ```bash
   drush en entity_ref_tab_formatter
   ```
3. Clear caches after enabling.

## Configuration

1. Navigate to the entity reference field you want to display (for example a
   Paragraph reference field) and open **Manage display**.
2. Choose **Entity reference tab formatter** in the *Format* column.
3. Configure the formatter:
   - **Tab title field**: pick the field whose value should appear in the tab or
     accordion header. When using Paragraphs a typical choice is
     `field_title` or `field_heading`. If that field is empty the formatter
     falls back to the referenced entity label.
   - **Tab body field**: select either a specific field from the referenced
     entity or choose **Rendered entity (full view)** to output the complete
     entity using a view mode.
   - **Rendered entity view mode** (visible only when the above option is
     selected): pick the view mode that should be used to render the referenced
     entity. Configure the view mode under **Structure → Paragraph types →
     Manage display** for each referenced bundle as needed.
   - **Display style**: choose **Tabs** or **Accordion**.
4. Save the display settings and clear caches if required.

## Tips

- When using Paragraphs, ensure each referenced bundle has the fields you map in
  the formatter. If a field is empty the formatter will display a friendly
  fallback message instead of a blank panel.
- The first tab/accordion item is expanded by default so users always see
  content even before JavaScript runs.
- If you add new bundles later, revisit the formatter settings to confirm the
  title/body mappings still make sense.

## Troubleshooting

- **Schema warnings**: confirm the module’s configuration schema file is present
  (`config/schema/entity_ref_tab_formatter.schema.yml`) and clear caches.
- **Blank output**: verify the formatter is assigned to the correct field and
  that referenced entities actually contain data in the mapped fields. Use the
  **Rendered entity** option when you want to inherit the referenced entity’s
  view-mode layout.

## License

This module is distributed under the same license as the rest of the project.
