/**
 * @file
 * Provides an accessible accordion behaviour.
 */

((Drupal, once) => {
    Drupal.behaviors.entityRefAccordionFormatter = {
        attach(context) {
            once('entity-ref-tab-accordion', '.entity-ref-tab-formatter-accordion', context).forEach((wrapper) => {
                const items = Array.from(wrapper.querySelectorAll('[data-entity-ref-accordion-item]'));

                if (!items.length) {
                    return;
                }

                items.forEach((item) => {
                    item.addEventListener('toggle', () => {
                        if (!item.open) {
                            return;
                        }

                        items.forEach((otherItem) => {
                            if (otherItem !== item) {
                                otherItem.open = false;
                            }
                        });
                    });
                });
            });
        },
    };
})(Drupal, once);
