<?php

namespace Drupal\entity_reference_direct_input\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for Entity Reference Direct Input settings.
 */
class EntityReferenceDirectInputSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['entity_reference_direct_input.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'entity_reference_direct_input_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('entity_reference_direct_input.settings');

    $form['description'] = [
      '#markup' => '<p>' . $this->t('This module enhances entity autocomplete fields for major core entity types by allowing users to directly enter entity IDs, URLs, or path aliases. Select which entity types should have enhanced autocomplete functionality.') . '</p>',
    ];

    $form['enabled_entities'] = [
      '#type' => 'checkboxes',
      '#title' => $this->t('Enable enhanced autocomplete for entity types'),
      '#description' => $this->t('Select which entity types should support direct ID/URL/alias input in autocomplete fields.'),
      '#options' => [
        'node' => $this->t('Node'),
        'user' => $this->t('User'),
        'taxonomy_term' => $this->t('Taxonomy Term'),
      ],
      '#default_value' => $config->get('enabled_entities') ?? [],
    ];

    $form['help'] = [
      '#type' => 'details',
      '#title' => $this->t('Usage Examples'),
      '#open' => FALSE,
    ];

    $form['help']['examples'] = [
      '#markup' => $this->t('<p>Once enabled, users can use entity reference autocomplete fields in the following ways:</p><ul><li><strong>Direct Entity ID:</strong> Type "123" or "#123" to reference entity with ID 123</li><li><strong>Email Address:</strong> Type "user@example.com" to reference a user by email (users only)</li><li><strong>URL Input:</strong> Paste a full URL like "https://example.com/node/123" or user path like "/user/123"</li><li><strong>Path Alias:</strong> Type "/my-page" or "my-page" for nodes and taxonomy terms</li></ul>'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('entity_reference_direct_input.settings')
      ->set('enabled_entities', array_filter($form_state->getValue('enabled_entities')))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
