<?php

namespace Drupal\entity_reference_direct_input\Hook;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for entity_reference_direct_input.
 */
class EntityReferenceDirectInputHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.entity_reference_direct_input':
        $output = '';
        $output .= '<h2>' . $this->t('About') . '</h2>';
        $output .= '<p>' . $this->t('The Entity Reference Direct Input module enhances entity autocomplete fields for major core entity types (Node, User, Taxonomy Term) by allowing users to directly enter entity IDs, email addresses (for users), URLs, or path aliases.') . '</p>';

        $output .= '<h2>' . $this->t('Features') . '</h2>';
        $output .= '<ul>';
        $output .= '<li>' . $this->t('Direct entity ID input (e.g., "123" or "#123")') . '</li>';
        $output .= '<li>' . $this->t('Email address support (for users, e.g., "user@example.com")') . '</li>';
        $output .= '<li>' . $this->t('Path alias resolution for nodes and taxonomy terms') . '</li>';
        $output .= '<li>' . $this->t('Per-entity-type configuration') . '</li>';
        $output .= '<li>' . $this->t('Respects field bundle restrictions') . '</li>';
        $output .= '</ul>';

        $output .= '<h2>' . $this->t('Configuration Required') . '</h2>';
        $output .= '<p><strong>' . $this->t('⚠️ IMPORTANT: This module requires manual configuration before it will work. By default, no entity types are enabled.') . '</strong></p>';
        $output .= '<p>' . $this->t('Configure the module at <a href=":url">Entity Reference Direct Input Settings</a> to enable enhanced autocomplete for specific entity types.', [
          ':url' => Url::fromRoute('entity_reference_direct_input.admin_settings')->toString(),
        ]) . '</p>';

        $output .= '<h2>' . $this->t('Usage') . '</h2>';
        $output .= $this->t('<p>Once configured, users can use entity reference autocomplete fields in the following ways:</p><ul><li><strong>Direct Entity ID:</strong> Type "123" or "#123" to reference entity with ID 123</li><li><strong>Email Address:</strong> Type "user@example.com" to reference a user by email (users only)</li><li><strong>URL Input:</strong> Paste a full URL like "https://example.com/node/123" or user path like "/user/123"</li><li><strong>Path Alias:</strong> Type "/my-page" or "my-page" for nodes and taxonomy terms</li></ul>');

        return $output;

      case 'system.admin_config_content':
        return '<p>' . $this->t('Configure <a href=":url">Entity Reference Direct Input settings</a> to enable enhanced autocomplete for specific entity types. <strong>Configuration is required - no entity types are enabled by default.</strong>', [
          ':url' => Url::fromRoute('entity_reference_direct_input.admin_settings')->toString(),
        ]) . '</p>';
    }
    return NULL;
  }

}
