# Translations

This directory contains translation files for the Entity Reference Direct Input module.

## Available Languages

- **French (fr)**: `entity_reference_direct_input.fr.po`
- **Spanish (es)**: `entity_reference_direct_input.es.po`

## Contributing Translations

To contribute translations for additional languages:

1. Copy the English strings from the source code and translate them
2. Create a `.po` file named `entity_reference_direct_input.[language_code].po` (e.g., `entity_reference_direct_input.de.po` for German)
3. Follow the GNU gettext format used in existing translation files
4. Submit a pull request with your translation

## Translation Guidelines

- Use proper terminology for Drupal concepts
- Maintain consistency with Drupal core translations
- Test translations in the actual interface
- Keep HTML tags intact (e.g., `<strong>`, `<a href="">`)
- Preserve placeholder variables (e.g., `:url`, `%s`)

## Testing Translations

To test translations:

1. Enable the language in Drupal admin
2. Set it as the default language
3. Clear caches
4. Navigate to the module's admin pages and help
5. Verify all strings are properly translated

## Questions?

If you have questions about translations, please open an issue on the project page.
