# Entity Reference Direct Input

Enhances entity reference autocomplete fields for major core entity types by allowing direct input of entity IDs, email addresses, URLs, or path aliases.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/entity_reference_direct_input).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/entity_reference_direct_input).

## Table of contents

- Overview
- Features
- Requirements
- Translations
- Installation
- Configuration
- Usage
- How It Works
- Technical Details
- Troubleshooting
- Development
- License
- Support

## Overview

This module extends Drupal's core entity autocomplete functionality for major core entity types. Instead of requiring users to search through autocomplete suggestions, they can directly enter:

- **Entity IDs**: `123` or `#123`
- **Email addresses**: `user@example.com` (for users only)
- **Full URLs**: `https://example.com/node/123`
- **Path aliases**: `/my-page` or `my-page`

The module will automatically resolve these inputs and provide immediate autocomplete suggestions.

## Features

- **Multi-Entity Support**: Works with major core entity types:
  - **Node** - Content pages
  - **User** - User accounts (with email support)
  - **Taxonomy Term** - Categories and tags
- **Per-Entity Configuration**: Enable/disable enhancement for specific entity types
- **Direct Entity ID input** (e.g., `123`, `#123`)
- **Email address support** (for users, e.g., `user@example.com`)
- **Full URL support** for entity pages
- **Path alias resolution** (for nodes and taxonomy terms)
- **Respects field bundle restrictions**
- **Language-safe alias resolution**
- **Admin configuration interface**

## Requirements

This module requires no modules outside of Drupal core.

- Drupal 10.2+ or Drupal 11.x
- PHP 8.1+

## Translations

This module includes translations for:
- **French (fr)**
- **Spanish (es)**

**Import**: To use translations:
1. Go to **Administration > Reports > Translations**
2. Click **Import** 
3. Upload the `.po` files from the `translations/` directory

Additional translations are welcome! See the `translations/` directory for contributing guidelines.

## Installation

### Via Composer (Recommended)

```bash
composer require drupal/entity_reference_direct_input
```

### Manual Installation

1. Download the module and place it in `modules/custom/entity_reference_direct_input`
2. Enable the module via the admin interface or Drush:
   ```bash
   drush en entity_reference_direct_input
   ```

## Configuration

**⚠️ IMPORTANT: Configuration Required**

This module requires manual configuration before it will work. By default, no entity types are enabled.

1. Navigate to **Administration > Configuration > Content authoring > Entity Reference Direct Input Settings**
2. **Select which entity types should have enhanced autocomplete functionality** (Node, User, Taxonomy Term)
3. Save the configuration

Without this configuration, the module will not enhance any autocomplete fields.

## Usage

Once configured, users can use entity reference autocomplete fields in the following ways:

### Direct Entity ID Input
- Type `123` to reference entity with ID 123
- Type `#123` to reference entity with ID 123

### Email Input (Users Only)
- Type `user@example.com` to reference a user by email
- The module will find the user and provide the suggestion

### URL Input
- Paste a full URL like `https://example.com/node/123`
- Paste user URLs like `https://example.com/user/123`
- Use user paths like `/user/123`
- The module will extract the entity ID and provide the suggestion

### Path Alias Input
- Type `/my-page` or `my-page` for nodes and taxonomy terms
- The module will resolve the alias to the corresponding entity

## How It Works

The module works by:

1. Extending Drupal's core `EntityAutocompleteMatcher` service
2. Intercepting autocomplete requests for configured entity types
3. Attempting to resolve the input string to an entity ID
4. Adding the resolved entity as the first suggestion if found
5. Respecting any bundle restrictions configured on the field

## Technical Details

- **Service Provider**: Replaces the core `entity.autocomplete_matcher` service
- **Multi-Entity Support**: Works with Node, User, and Taxonomy Term entities
- **Per-Entity Configuration**: Each entity type can be enabled/disabled independently
- **Bundle Aware**: Respects field-level bundle restrictions
- **Language Safe**: Uses Drupal's path validator for proper alias resolution
- **Route Mapping**: Maps entity canonical routes to entity types for URL resolution

## Troubleshooting

### Module Not Working
- Ensure the module is enabled
- Check that you're using entity reference fields for configured entity types
- Verify the entity types are enabled in the admin settings

### Path Aliases Not Resolving
- Ensure path aliases are properly configured
- Check that the alias points to a valid entity
- Verify language settings if using multilingual sites
- Note: Path aliases only work for nodes and taxonomy terms

## Development

### Extending for Custom Entity Types

To extend this module for custom entity types, modify the `resolveToEntityId()` method in `EntityReferenceDirectInputMatcher.php`:

```php
// Add your custom entity type to the route mapping
$route_mapping = [
  'entity.node.canonical' => ['entity_type' => 'node', 'param' => 'node'],
  'entity.user.canonical' => ['entity_type' => 'user', 'param' => 'user'],
  'entity.taxonomy_term.canonical' => ['entity_type' => 'taxonomy_term', 'param' => 'taxonomy_term'],
  // Add your custom entity type
  'entity.my_custom_entity.canonical' => ['entity_type' => 'my_custom_entity', 'param' => 'my_custom_entity'],
];
```

Then add the entity type to the admin form options and configuration schema.

### Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Submit a pull request

## License

This project is licensed under the GPL-2.0-or-later license.

## Maintainers

- [ewehbe](https://www.drupal.org/u/ewehbe)

## Support

- **Issues**: [Drupal.org project issues](https://www.drupal.org/project/issues/entity_reference_direct_input)
- **Documentation**: [Drupal.org project page](https://www.drupal.org/project/entity_reference_direct_input)
