<?php

namespace Drupal\Tests\entity_reference_integrity_enforce\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Test the predelete hook.
 *
 * @group entity_reference_integrity_enforce
 */
class EntityPredeleteHookTest extends KernelTestBase {

  /**
   * Modules that implement hook_entity_predelete().
   *
   * @var array
   */
  protected static $modules = [
    'comment',
    'entity_reference_integrity_enforce',
  ];

  /**
   * Test the entity_predelete implementations.
   */
  public function testHook() {

    // Get a list of all implementors of hook_entity_predelete().
    $implementors = [];
    \Drupal::moduleHandler()->invokeAllWith('entity_predelete', function (callable $hook, string $module) use (&$implementors) {
      $implementors[] = $module;
    });

    // Confirm that our hook is the first in the list, and comment is second.
    $this->assertEquals('entity_reference_integrity_enforce', reset($implementors));
    $this->assertEquals('comment', next($implementors));
  }

}
