<?php

namespace Drupal\entity_reference_manager;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Modifies the content merge service to register handlers.
 */
class ContentMergeServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container): void {
    if (!$container->has('entity_reference_manager.manager')) {
      return;
    }

    $definition = $container->getDefinition('entity_reference_manager.manager');
    $tagged_services = $container->findTaggedServiceIds('entity_reference_manager.handler');
    foreach ($tagged_services as $id => $tags) {
      $definition->addMethodCall('registerHandler', [
        new Reference($id),
      ]);
    }
  }

}
