<?php

namespace Drupal\entity_reference_manager\Handler;

use Drupal\Core\Entity\EntityInterface;

/**
 * Interface for content merge handlers.
 */
interface ContentMergeHandlerInterface {

  /**
   * Determines if the handler supports the given entity.
   */
  public function supports(EntityInterface $entity): bool;

  /**
   * Analyzes the content merge.
   */
  public function analyze(EntityInterface $source, EntityInterface $target, array $options = []): array;

  /**
   * Executes the content merge.
   */
  public function execute(EntityInterface $source, EntityInterface $target, array $options = []): void;

}
