/**
 * @file
 * Your custom code into javascript behaviour.
 */

(function ($, Drupal, settings) {

  Drupal.behaviors.datepickerInit = {
    attach: function (context, settings) {
      var forms = drupalSettings.entity_reservation_system.forms || [];
      forms.forEach(function (item) {
        var minDate = 0;
        var firstDay = 0;
        if (item.allow_all_calendar) {
          minDate = "-1y";
        }
        if (item.first_day) {
          firstDay = item.first_day;
        }
        $(once('bind-datepicker-reservation', '.' + item['wrapper_datepicker'], context)).each(function () {
          $(this).once('reservation-datepicker').datepicker({
            changeMonth: true,
            changeYear: true,
            minDate: minDate,
            firstDay: firstDay,
            dateFormat: 'yy-mm-dd',
            altField : '.' + item['wrapper_datevalue'],
            defaultDate: $('.' + item['wrapper_datevalue']).val(),
            onSelect: function () {
              $('.' + item['wrapper_datevalue']).change();
            }
          });
        });

        var wrapper_units = '.' + item.wrapper_units;
        if ($('.form-item-' + item.units_field_name + '-all', wrapper_units).length) {
          $(once('bind-select-all-units', '.form-item-' + item.units_field_name + '-all input.form-checkbox', context)).each(function() {
            $(this, wrapper_units).click(function () {
              $(this, wrapper_units).closest('.form-checkboxes').find('input.form-checkbox').prop('checked', $(this).prop('checked'));
            });
          });
          $(once('bind-unselect-all-units', '.form-type-checkbox:not(.form-item-' + item.units_field_name + '-all) input', context)).each(function() {
            $(this, wrapper_units).click(function () {
              $(this, wrapper_units).closest('.form-checkboxes').find('.form-item-' + item.units_field_name + '-all input').prop('checked', false);
            });
          });
        }
        item.incompatible_units.forEach(function (incompatible) {
          if ($('.form-item-' + item.units_field_name + '-' + incompatible, wrapper_units).length) {
            $(once('bind-select-' + incompatible + '-units', '.form-item-' + item.units_field_name + '-' + incompatible + ' input.form-checkbox', context)).each(function() {
              $(this, wrapper_units).click(function () {
                $(this, wrapper_units).closest('.form-checkboxes').find('.form-type-checkbox:not(.form-item-' + item.units_field_name + '-' + incompatible + ') input.form-checkbox').prop('checked', false);
              });
            });
            $(once('bind-unselect-' + incompatible + '-units', '.form-type-checkbox:not(.form-item-' + item.units_field_name + '-' + incompatible + ') input', context)).each(function() {
              $(this, wrapper_units).click(function () {
                $(this, wrapper_units).closest('.form-checkboxes').find('.form-item-' + item.units_field_name + '-' + incompatible + ' input').prop('checked', false);
              });
            });
          }
        });
        var wrapper_timeslots = '.' + item.wrapper_timeslots;
        if ($('.form-item-timeslots-all', wrapper_timeslots).length) {
          $(once('bind-select-all-timeslots', '.form-item-timeslots-all input.form-checkbox', context)).each(function() {
            $(this, wrapper_timeslots).click(function () {
              $(this, wrapper_timeslots).closest('.form-checkboxes').find('input.form-checkbox').prop('checked', $(this).prop('checked'));
            });
          });
          $(once('bind-unselect-all-timeslots', '.form-type-checkbox:not(.form-item-timeslots-all) input', context)).each(function() {
            $(this, wrapper_timeslots).click(function () {
              $(this, wrapper_timeslots).closest('.form-checkboxes').find('.form-item-timeslots-all input').prop('checked', false);
            });
          });
        }
      });
    }
  }

})(jQuery, Drupal, drupalSettings);
