# Entity Revision Diff

Extends the [Diff](https://www.drupal.org/project/diff) module to provide **visual revision comparison** for non-node content entities.

## The Problem

Drupal 10.2+ and 11 core includes **version history UI** for revisionable entities (list revisions, revert, delete). However, core provides **only a simple list** — it does NOT include:

- **Visual diff comparison** between any two revisions
- **Radio button selection** for choosing which revisions to compare
- Side-by-side or unified view of what changed

The [Diff](https://www.drupal.org/project/diff) module adds this functionality, but **only for nodes** out of the box.

## What This Module Does

Entity Revision Diff bridges this gap by integrating Diff module's comparison functionality with other entity types:

| Entity Type | Requires |
|-------------|----------|
| Group | [Group](https://www.drupal.org/project/group) module (optional) |
| Block Content | Drupal core |
| Media | Drupal core |
| Taxonomy Term | Drupal core |

Note: Node entities are handled by the Diff module directly.

## Requirements

- Drupal 10.2+ or 11
- [Diff](https://www.drupal.org/project/diff) module (2.0.0-beta4+)

### Optional

- [Group](https://www.drupal.org/project/group) — enables revision diff for Group entities

## Installation

```bash
composer require drupal/entity_revision_diff
drush en entity_revision_diff
```

## Paths

| Entity Type | Version History | Diff Comparison |
|-------------|-----------------|-----------------|
| Group | `/group/{id}/revisions` | `/group/{id}/revisions/view/{left}/{right}` |
| Block Content | `/admin/content/block/{id}/revisions` | `/admin/content/block/{id}/revisions/view/{left}/{right}` |
| Media | `/media/{id}/revisions` | `/media/{id}/revisions/view/{left}/{right}` |
| Taxonomy Term | `/taxonomy/term/{id}/revisions` | `/taxonomy/term/{id}/revisions/view/{left}/{right}` |

## Features

- Radio button selection for comparing two revisions
- Integration with Diff module's comparison layouts (Unified, Split, Visual Inline)
- Translation-aware revision revert forms
- Bundle-specific revision permissions
- Views field for current revision ID

## Permissions

### Global permissions

- `view all {entity_type} revisions`
- `revert all {entity_type} revisions`
- `delete all {entity_type} revisions`

### Bundle-specific permissions

Generated dynamically for each bundle:

- `view {bundle} revisions`
- `revert {bundle} revisions`
- `delete {bundle} revisions`

## Architecture

This module uses Diff 2.0's `DiffRouteProvider` to automatically generate revision comparison routes. It replaces the version history controller with a form that includes diff radio buttons.

### Key Components

| Component | Purpose |
|-----------|---------|
| `EntityRevisionOverviewForm` | Version history with diff radio buttons |
| `EntityRevisionRevertTranslationForm` | Revert specific translation to revision |
| `EntityDiffRouteSubscriber` | Replaces version_history routes with diff-enabled form |
| `EntityDiffPermissions` | Generates bundle-specific permissions |
| `EntityCurrentRevisionVID` | Views field for current revision ID |
| `GroupRouteProvider` | Dynamic routes for Group entities (when installed) |

## Development

### Running Tests

```bash
ddev ssh
cd /var/www/html/docroot
SIMPLETEST_BASE_URL='http://web' SIMPLETEST_DB='mysql://db:db@db/db' \
  ../bin/phpunit -c core/phpunit.xml.dist modules/contrib/entity_revision_diff/tests/ --testdox
```

### Test Coverage

- **92 tests, 2040 assertions**
- Unit tests: Views field plugin
- Kernel tests: Routes, permissions, entity type alterations
- Functional tests: UI interaction, form submission

## Migration from entity_diff_ui

This module replaces `entity_diff_ui` (deprecated for Drupal 11). Key differences:

| Feature | entity_diff_ui | entity_revision_diff |
|---------|----------------|---------------------|
| Drupal 11 support | No | Yes |
| Diff 2.0 API | No | Yes |
| Group support | No | Yes |
| Architecture | Base + submodules | Single unified module |

All URLs and permissions remain backward compatible.
